const { DataTypes } = require('sequelize');
const { sequelize } = require('../config/database');
const { Proveedor } = require('../models/proveedor.model');

const Usuario = sequelize.define('Usuario', {
    gen_id_usuario: {
        type: DataTypes.INTEGER,
        primaryKey: true,
        autoIncrement: true,
        field: 'gen_id_usuario',
    },
    gen_nombre: {
        type: DataTypes.STRING(255),
        allowNull: true,
        field: 'gen_nombre',
    },
    gen_apellido_paterno: {
        type: DataTypes.STRING(255),
        allowNull: true,
        field: 'gen_apellido_paterno',
    },
    gen_apellido_materno: {
        type: DataTypes.STRING(255),
        allowNull: true,
        field: 'gen_apellido_materno',
    },
    gen_email: {
        type: DataTypes.STRING(255),
        allowNull: true,
        unique: true,
        field: 'gen_email',
    },
    gen_telefono_contacto: {
        type: DataTypes.STRING(255),
        allowNull: true,
        field: 'gen_telefono_contacto',
    },
    gen_password: {
        type: DataTypes.STRING(255),
        allowNull: true,
        field: 'gen_password',
    },
    gen_estado: {
        type: DataTypes.ENUM('0', '1'),
        defaultValue: '1',
        field: 'gen_estado',
    },
    gen_dni: {
        type: DataTypes.STRING(255),
        allowNull: true,
        field: 'gen_dni',
    },
    gen_fecha_registro_usuario: {
        type: DataTypes.DATE,
        allowNull: false,
        defaultValue: sequelize.literal('CURRENT_TIMESTAMP'),
    },
    gen_agronomo_fcm_token: {
        type: DataTypes.STRING(500),
        allowNull: true,
        field: 'gen_agronomo_fcm_token',
    },
    gen_es_administrador: {
        type: DataTypes.ENUM('0', '1'),
        defaultValue: '0',
        field: 'gen_es_administrador',
    },
    fk_tbl_proveedor_gen_idtbl_proveedor: {
        type: DataTypes.INTEGER,
        allowNull: true,
        field: 'fk_tbl_proveedor_gen_idtbl_proveedor',
        references: {
            model: Proveedor,
            key: 'gen_idtbl_proveedor',
        },
    }

}, {
    tableName: 'tbl_usuario',
    timestamps: false, // Sin createdAt y updatedAt
    underscored: true,
});

module.exports = { Usuario };

