const { DataTypes } = require('sequelize');
const { sequelize } = require('../config/database');
const { Pais } = require('../models/pais.model');

const Temporada = sequelize.define('Temporada' ,{
    gen_idtbl_temporada: {
        type: DataTypes.INTEGER,
        allowNull: false,
        primaryKey: true,
        autoIncrement: true,
        field: 'gen_idtbl_temporada'
    },
    gen_cod_manual_temporada: {
        type: DataTypes.STRING(45),
        allowNull: true,
        field: 'gen_cod_manual_temporada'
    },
    gen_nombre_temporada: {
        type: DataTypes.STRING(45),
        allowNull: true,
        field: 'gen_nombre_temporada'
    },
    gen_desde_temporada: {
        type: DataTypes.DATE,
        allowNull: true,
        field: 'gen_desde_temporada'
    },
    gen_hasta_temporada: {
        type: DataTypes.DATE,
        allowNull: true,
        field: 'gen_hasta_temporada'
    },
    gen_estado_temporada:{
        type: DataTypes.ENUM('0','1'),
        allowNull: true,
        field: 'gen_estado_temporada',
        defaultValue: '1'
    },
    gen_registro_temporada: {
        type: DataTypes.DATE,
        allowNull: true,
        field: 'gen_registro_temporada'
    },
    gen_fk_pais: {
        type: DataTypes.INTEGER,
        allowNull: true,
        references: {
            model: Pais,
            key: 'gen_id_pais'
        },
        field: 'gen_fk_pais'
    }
}, {
    tableName: 'tbl_temporada',
    timestamps: false,
});

module.exports = { Temporada };