const { DataTypes } = require('sequelize');
const { sequelize } = require('../config/database');
const { Predio } = require('../models/predio.model');
const { Temporada } = require('../models/temporada.model');
const { Especie } = require('../models/especie.model');
const { Proveedor } = require('../models/proveedor.model');
const { Pais } = require('../models/pais.model');
const { Calidad } = require('../models/calidad.model');

const RecepcionHeader = sequelize.define('RecepcionHeader', {
    gen_idtbl_recepcion: {
        type: DataTypes.INTEGER,
        allowNull: false,
        primaryKey: true,
        autoIncrement: true,
        field: 'gen_idtbl_recepcion'
    },
    gen_registro_recepcion: {
        type: DataTypes.DATE,
        allowNull: true,
        field: 'gen_registro_recepcion'
    },
    gen_guia_recepcion: {
        type: DataTypes.STRING(45),
        allowNull: true,
        field: 'gen_guia_recepcion'
    },
    gen_fecha_recepcion: {
        type: DataTypes.DATE,
        allowNull: true,
        field: 'gen_fecha_recepcion'
    },
    gen_fk_tbl_pais_id_pais: {
        type: DataTypes.INTEGER,
        allowNull: false,
        field: 'gen_fk_tbl_pais_id_pais',
        references: {
            model: Pais,
            key: 'gen_id_pais',
        },
    },
    gen_fk_tbl_temporada_idtbl_temporada: {
        type: DataTypes.INTEGER,
        allowNull: false,
        field: 'gen_fk_tbl_temporada_idtbl_temporada',
        references: {
            model: Temporada,
            key: 'gen_idtbl_temporada',
        },
    },
    gen_fk_tbl_predio_idtbl_predio: {
        type: DataTypes.INTEGER,
        allowNull: false,
        field: 'gen_fk_tbl_predio_idtbl_predio',
        references: {
            model: Predio,
            key: 'gen_idtbl_predio',
        },
    },
    gen_tbl_especie_gen_idtbl_especie: {
        type: DataTypes.INTEGER,
        allowNull: false,
        field: 'gen_tbl_especie_gen_idtbl_especie',
        references: {
            model: Especie,
            key: 'gen_idtbl_especie',
        },
    },
    gen_fk_tbl_recepcion_calidad_idtbl_recepcion_calidad: { // Nueva columna
        type: DataTypes.INTEGER,
        allowNull: true, 
        field: 'gen_fk_tbl_recepcion_calidad_idtbl_recepcion_calidad',
        references: {
            model: Calidad, 
            key: 'idtbl_recepcion_calidad',
        },
    },
    url_view: {
        type: DataTypes.STRING(500),
        allowNull: true, // Puede ser null inicialmente
        field: 'url_view'
    },
    gen_fk_tbl_proveedor_idtbl_proveedor: {
        type: DataTypes.INTEGER,
        allowNull: true,
        field: 'gen_fk_tbl_proveedor_idtbl_proveedor',
        references: {
            model: Proveedor,
            key: 'gen_idtbl_proveedor',
        },
    },
}, {
    tableName: 'tbl_recepcion_header',
    timestamps: false,
});

module.exports = { RecepcionHeader };