const { DataTypes } = require('sequelize');
const { sequelize } = require('../config/database');
// const { zMantProductor } = require('../models/zmantproductor.model');
// const { Usuario } = require('../models/usuario.model');

const Proveedor = sequelize.define('proveedor', {
    gen_idtbl_proveedor: {
        type: DataTypes.INTEGER,
        primaryKey: true,
        autoIncrement: true,
        allowNull: false,
        field: 'gen_idtbl_proveedor',
    },
    gen_nombre_proveedor: {
        type: DataTypes.STRING(45),
        allowNull: false,
        field: 'gen_nombre_proveedor',
    },
    gen_rut_proveedor: {
        type: DataTypes.STRING(45),
        allowNull: false,
        field: 'gen_rut_proveedor',
    },
    gen_registro_proveedor: {
        type: DataTypes.DATE,
        allowNull: false,
        field: 'gen_registro_proveedor',
        defaultValue: sequelize.literal('CURRENT_TIMESTAMP'),
    },
    gen_codigo_bot: {
        type: DataTypes.STRING(255),
        allowNull: true,
        unique: true,
        field: 'gen_codigo_bot',
    },
    gen_fk_tbl_pais_id_pais: {
        type: DataTypes.INTEGER,
        allowNull: false,
        field: 'gen_fk_tbl_pais_id_pais',
        references: {
            model: 'tbl_pais',
            key: 'gen_id_pais',
        },
    },
    gen_fk_tbl_sap_zmant_productor_idtbl_sap_zmant_productor: {
        type: DataTypes.INTEGER,
        allowNull: true,
        field: 'gen_fk_tbl_sap_zmant_productor_idtbl_sap_zmant_productor',
        references: {
            model: 'tbl_sap_zmant_productor',
            key: 'idtbl_sap_zmant_productor',
        },
    },
    fk_tbl_usuario_gen_id_usuario: {
        type: DataTypes.INTEGER,
        allowNull: true,
        field: 'fk_tbl_usuario_gen_id_usuario',
        references: {
            model: 'tbl_usuario',
            key: 'gen_id_usuario',
        },
    }
}, {
    tableName: 'tbl_proveedor',
    timestamps: false,
});

module.exports = { Proveedor };