const { DataTypes } = require('sequelize');
const { sequelize } = require('../config/database');
const { ProcesoTipoCalibre } = require('../models/procesoTipoCalibre.model');
const { ProcesoMaterial } = require('../models/procesoMaterial.model');
const { ProcesoHeader } = require('../models/procesoHeader.model');
const { ProcesoCalibreTipo } = require('../models/procesoCalibreTipo.model');

const ProcesoOut = sequelize.define('ProcesoOut', {
    gen_idtbl_out_op: {
        type: DataTypes.INTEGER,
        allowNull: false,
        primaryKey: true,
        autoIncrement: true,
        field: 'gen_idtbl_out_op'
    },
    gen_cantidad_out_op: {
        type: DataTypes.FLOAT,
        allowNull: false,
        field: 'gen_cantidad_out_op'
    },
    gen_categoria_out_op: {
        type: DataTypes.STRING(45),
        allowNull: false,
        field: 'gen_categoria_out_op'
    },
    gen_fk_tbl_header_op_idtbl_header_op: {
        type: DataTypes.INTEGER,
        allowNull: false,
        field: 'gen_fk_tbl_header_op_idtbl_header_op',
        references: {
            model: ProcesoHeader,
            key: 'gen_idtbl_header_op',
        },
    },
    gen_fk_tbl_material_idtbl_material: {
        type: DataTypes.INTEGER,
        allowNull: false,
        field: 'gen_fk_tbl_material_idtbl_material',
        references: {
            model: ProcesoMaterial,
            key: 'gen_idtbl_material',
        },
    },
    gen_fk_tbl_calibre_tipo_gen_idtbl_calibre_tipo: {
        type: DataTypes.INTEGER,
        allowNull: false,
        field: 'gen_fk_tbl_calibre_tipo_gen_idtbl_calibre_tipo',
        references: {
            model: ProcesoCalibreTipo,
            key: 'gen_idtbl_calibre_tipo',
        },
      },      
    gen_destino_op: {
        type: DataTypes.INTEGER,
        allowNull: false,
        field: 'gen_destino_op'
    },
    extra_2: {
        type: DataTypes.STRING(45),
        allowNull: true,
        field: 'extra_2'
    },
    extra_3: {
        type: DataTypes.STRING(45),
        allowNull: true,
        field: 'extra_3'
    },
}, {
    tableName: 'tbl_out_op',
    timestamps: false,
});

module.exports = {
    ProcesoOut
}