const { DataTypes } = require('sequelize');
const { sequelize } = require('../config/database');
const { Especie } = require('../models/especie.model');
const { Predio } = require('../models/predio.model');
const { Temporada } = require('../models/temporada.model');
const { Proveedor } = require('../models/proveedor.model');
const { ProcesoTipo} = require('../models/procesoTipo.model');
const { ProcesoSetup } = require('../models/procesoSetup.model');
const { Variedad } = require('../models/variedad.model');

const ProcesoHeader = sequelize.define('ProcesoHeader', {
    gen_idtbl_header_op: {
        type: DataTypes.INTEGER,
        allowNull: false,
        primaryKey: true,
        autoIncrement: true,
        field: 'gen_idtbl_header_op'
    },
    gen_fecha_header_op: {
        type: DataTypes.DATE,
        allowNull: false,
        field: 'gen_fecha_header_op'
    },
    gen_orden_produccion: {
        type: DataTypes.STRING(45),
        allowNull: false,
        field: 'gen_orden_produccion'
    },
    gen_referencia_header_op: {
        type: DataTypes.STRING(45),
        allowNull: false,
        field: 'gen_referencia_header_op'
    },
    gen_exp_header_op: {
        type: DataTypes.STRING(45),
        allowNull: false,
        field: 'gen_exp_header_op'
    },
    gen_estado_op: {
        type:DataTypes.ENUM('0', '1', '2'),
        allowNull: false,
        field: 'gen_estado_op',
        defaultValue: '0'
    },
    gen_comentarios_op: {
        type: DataTypes.STRING(500),
        allowNull: true,
        field: 'gen_comentarios_op'
    },
    gen_fk_tbl_temporada_gen_idtbl_temporada: {
        type: DataTypes.INTEGER,
        allowNull: false,
        field: 'gen_fk_tbl_temporada_gen_idtbl_temporada',
        references: {
            model: Temporada,
            key: 'gen_idtbl_temporada',
        },
    },
    gen_fk_tbl_especie_gen_idtbl_especie: {
        type: DataTypes.INTEGER,
        allowNull: false,
        field: 'gen_fk_tbl_especie_gen_idtbl_especie',
        references: {
            model: Especie,
            key: 'gen_idtbl_especie',
        },
    },
    gen_fk_tbl_variedad_idtbl_variedad: {
        type: DataTypes.INTEGER,
        allowNull: true,
        field: 'gen_fk_tbl_variedad_idtbl_variedad',
        references: {
            model: Variedad,
            key: 'idtbl_variedad',
        },
    },
    gen_fk_tbl_predio_gen_idtbl_predio: {
        type: DataTypes.INTEGER,
        allowNull: false,
        field: 'gen_fk_tbl_predio_gen_idtbl_predio',
        references: {
            model: Predio,
            key: 'gen_idtbl_predio',
        },
    },
    gen_fk_tbl_tipo_op_idtbl_tipo_op: {
        type: DataTypes.INTEGER,
        allowNull: false,
        field: 'gen_fk_tbl_tipo_op_idtbl_tipo_op',
        references: {
            model: ProcesoTipo,
            key: 'gen_idtbl_tipo_op',
        },
    },
    gen_fk_tbl_proveedor_idtbl_proveedor: {
        type: DataTypes.INTEGER,
        allowNull: false,
        field: 'gen_fk_tbl_proveedor_idtbl_proveedor',
        references: {
            model: Proveedor,
            key: 'idtbl_proveedor',
        },
    },
    gen_fk_tbl_proceso_setup_idtbl_proceso_setup : {
        type: DataTypes.INTEGER,
        allowNull: true,
        field: 'gen_fk_tbl_proceso_setup_idtbl_proceso_setup',
        references: {
            model: ProcesoSetup,
            key: 'idtbl_proceso_setup',
        },
    },
    extra_1: {
        type: DataTypes.STRING(45),
        allowNull: true,
        field: 'extra_1'
    },
    extra_2: {
        type: DataTypes.STRING(45),
        allowNull: true,
        field: 'extra_2'
    },
    extra_3: {
        type: DataTypes.STRING(45),
        allowNull: true,
        field: 'extra_3'
    },
}, {
    tableName: 'tbl_header_op',
    timestamps: false,
});

module.exports = {
    ProcesoHeader
}