const { DataTypes } = require('sequelize');
const { sequelize } = require('../config/database');
const { ProcesoCalibre } = require('../models/procesoCalibre.model');
const { ProcesoTipoCalibre } = require('../models/procesoTipoCalibre.model');


const ProcesoCalibreTipo = sequelize.define('proceso_calibre_tipo', {
    gen_idtbl_calibre_tipo: {
        type: DataTypes.INTEGER,
        allowNull: false,
        primaryKey: true,
        autoIncrement: true,
        field: 'gen_idtbl_calibre_tipo'
    },
    gen_fk_tbl_tipo_calibre_gen_idtbl_tipo_calibre: {
        type: DataTypes.INTEGER,
        allowNull: false,
        field: 'gen_fk_tbl_tipo_calibre_gen_idtbl_tipo_calibre',
        references: {
            model: ProcesoTipoCalibre,
            key: 'gen_idtbl_tipo_calibre',
        },
    },
    gen_fk_tbl_calibre_gen_idtbl_calibre: {
        type: DataTypes.INTEGER,
        allowNull: false,
        field: 'gen_fk_tbl_calibre_gen_idtbl_calibre',
        references: {
            model: ProcesoCalibre,
            key: 'gen_idtbl_calibre',
        },
    },
    fk_calibre_equivalente_tbl_calibre: {
        type: DataTypes.INTEGER,
        allowNull: true,
        field: 'fk_calibre_equivalente_tbl_calibre',
        references: {
            model: ProcesoCalibre,
            key: 'gen_idtbl_calibre',
        },
    },
},
    {
        tableName: 'tbl_calibre_tipo',
        timestamps: false,
    });

module.exports = { ProcesoCalibreTipo }