const { DataTypes } = require('sequelize');
const { sequelize } = require('../config/database');
const { Especie } = require('../models/especie.model');

const ProcesoCalibre = sequelize.define('proceso_calibre', {
    gen_idtbl_calibre: {
        type: DataTypes.INTEGER,
        allowNull: false,
        primaryKey: true,
        autoIncrement: true,
        field: 'gen_idtbl_calibre'
    },
    gen_nombre_calibre: {
        type: DataTypes.STRING(45),
        allowNull: false,
        field: 'gen_nombre_calibre'
    },
    gen_fk_tbl_especie_gen_idtbl_especie: {
        type: DataTypes.INTEGER,
        allowNull: false,
        field: 'gen_fk_tbl_especie_gen_idtbl_especie',
        references: {
            model: Especie,
            key: 'gen_idtbl_especie',
        },
    },
    mercado_default: {
        type: DataTypes.INTEGER,
        allowNull: false,
        field: 'mercado_default'
    },
}, {
    tableName: 'tbl_calibre',
    timestamps: false,
});

module.exports = { ProcesoCalibre }