const { DataTypes } = require('sequelize');
const { sequelize } = require('../config/database');
const { zMantProductorSdp } = require('../models/zmantproductorsdp.model');

const Predio = sequelize.define('predio', {
    gen_idtbl_predio: {
        type: DataTypes.INTEGER,
        primaryKey: true,
        autoIncrement: true,
        allowNull: false,
        field: 'gen_idtbl_predio',
    },
    gen_fk_tbl_proveedor_idtbl_proveedor: {
        type: DataTypes.INTEGER,
        allowNull: false,
        field: 'gen_fk_tbl_proveedor_idtbl_proveedor',
    },
    gen_nombre_predio: {
        type: DataTypes.STRING,
        allowNull: false,
        field: 'gen_nombre_predio',
    },
    gen_cod_csg: {
        type: DataTypes.STRING(500),
        allowNull: true,
        field: 'gen_cod_csg',
    },
    gen_cod_sdp: {
        type: DataTypes.STRING(500),
        allowNull: true,
        field: 'gen_cod_sdp',
    },
    gen_rut_predio: {
        type: DataTypes.STRING(500),
        allowNull: true,
        field: 'gen_rut_predio',
    },
    gen_fk_tbl_sap_zmant_productor_sdp_idtbl_sap_zmant_productor_sdp: {
        type: DataTypes.INTEGER,
        allowNull: true,
        field: 'gen_fk_tbl_sap_zmant_productor_sdp_idtbl_sap_zmant_productor_sdp',
        references: {
            model: zMantProductorSdp,
            key: 'idtbl_sap_zmant_productor_sdp',
        },
    }
}, {
    tableName: 'tbl_predio',
    timestamps: false,
});

module.exports = { Predio };

