const { DataTypes } = require('sequelize');
const { sequelize } = require('../config/database');
const { Usuario } = require('../models/usuario.model');

const Logs =  sequelize.define('Logs', {
    idtbl_logs_auditoria: {
        type: DataTypes.INTEGER,
        allowNull: false,
        primaryKey: true,
        autoIncrement: true,
        field: 'idtbl_logs_auditoria'
    },
    gen_fk_tbl_usuario_gen_id_usuario: {
        type: DataTypes.INTEGER,
        allowNull: true,
       references: {
            model: Usuario,
            key: 'gen_id_usuario',
        },
        field: 'gen_fk_tbl_usuario_gen_id_usuario'
    },
    gen_accion: {
        type: DataTypes.STRING(250),
        allowNull: true,
        field: 'gen_accion'
    },
    gen_descripcion: {
        type: DataTypes.STRING(500),
        allowNull: true,
        field: 'gen_descripcion'
    },
    gen_fecha: {
        type: DataTypes.DATE,
        allowNull: false,
        defaultValue: DataTypes.NOW,
        field: 'gen_fecha'
    }
}, {
    tableName: 'tbl_logs_auditoria',
    timestamps: false,
});

module.exports = { Logs };