const { DataTypes } = require('sequelize');
const { sequelize } = require('../config/database');

const Especie =  sequelize.define('Especie', {
    gen_idtbl_especie: {
        type: DataTypes.INTEGER,
        allowNull: false,
        primaryKey: true,
        autoIncrement: true,
        field: 'gen_idtbl_especie'
    },
    gen_nombre_especie: {
        type: DataTypes.STRING(45),
        allowNull: true,
        field: 'gen_nombre_especie'
    },
    gen_cod_especie: {
        type: DataTypes.STRING(45),
        allowNull: true,
        field: 'gen_cod_especie'
    },
    gen_registro_especie: {
        type: DataTypes.DATE,
        allowNull: true,
        field: 'gen_registro_especie'
    },
    gen_matnr_cod_especie: {
        type: DataTypes.STRING(250),
        allowNull: true,
        field: 'gen_matnr_cod_especie'
    },
}, {
    tableName: 'tbl_especie',
    timestamps: false,
});

module.exports = { Especie };