const { DataTypes } = require('sequelize');
const { sequelize } = require('../config/database');

const Calidad = sequelize.define('Calidad', {
    idtbl_recepcion_calidad: {
        type: DataTypes.INTEGER,
        allowNull: false,
        primaryKey: true,
        autoIncrement: true,
        field: 'idtbl_recepcion_calidad'
    },
    id_lote:{
        type: DataTypes.INTEGER,
        allowNull: true,
        field: 'id_lote'
    },
    fec_bat:{
        type: DataTypes.DATE,
        allowNull: true,
        field: 'fec_bat'
    },
    ano_mes:{
        type: DataTypes.INTEGER,
        allowNull: true,
        field: 'ano_mes'
    },
    nom_loc:{
        type: DataTypes.STRING(45),
        allowNull: true,
        field: 'nom_loc'
    },
    nom_insp:{
        type: DataTypes.STRING(45),
        allowNull: true,
        field: 'nom_insp'
    },
    nom_sup:{
        type: DataTypes.STRING(45),
        allowNull: true,
        field: 'nom_sup'
    },
    nom_esp:{
        type: DataTypes.STRING(45),
        allowNull: true,
        field: 'nom_esp'
    },
    nom_var:{
        type: DataTypes.STRING(45),
        allowNull: true,
        field: 'nom_var'
    },
    nom_gro:{
        type: DataTypes.STRING(45),
        allowNull: true,
        field: 'nom_gro'
    },
    cod_csg:{
        type: DataTypes.STRING(45),
        allowNull: true,
        field: 'cod_csg'
    },
    cod_reg:{
        type: DataTypes.STRING(45),
        allowNull: true,
        field: 'cod_reg'
    },
    nom_zon:{
        type: DataTypes.STRING(45),
        allowNull: true,
        field: 'nom_zon'
    },
    nom_grp:{
        type: DataTypes.STRING(45),
        allowNull: true,
        field: 'nom_grp'
    },
    cod_sdp:{
        type: DataTypes.STRING(45),
        allowNull: true,
        field: 'cod_sdp'
    },
    sector:{
        type: DataTypes.STRING(45),
        allowNull: true,
        field: 'sector'
    },
    fec_rec:{
        type: DataTypes.DATE,
        allowNull: true,
        field: 'fec_rec'
    },
    fec_cos:{
        type: DataTypes.DATE,
        allowNull: true,
        field: 'fec_cos'
    },
    fec_lav:{
        type: DataTypes.DATE,
        allowNull: true,
        field: 'fec_lav'
    },
    lote:{
        type: DataTypes.STRING(45),
        allowNull: true,
        field: 'lote'
    },
    num_gui:{
        type: DataTypes.STRING(45),
        allowNull: true,
        field: 'num_gui'
    },
    qty:{
        type: DataTypes.INTEGER,
        allowNull: true,
        field: 'qty'
    },
    pes_lot:{
        type: DataTypes.STRING(45),
        allowNull: true,
        field: 'pes_lot'
    },
    muestra:{
        type: DataTypes.STRING(45),
        allowNull: true,
        field: 'muestra'
    },
    scr_qlty:{
        type: DataTypes.INTEGER,
        allowNull: true,
        field: 'scr_qlty'
    },
    scr_cond:{
        type: DataTypes.STRING(45),
        allowNull: true,
        field: 'scr_cond'
    },
    por_exp:{
        type: DataTypes.STRING(45),
        allowNull: true,
        field: 'por_exp'
    },
    res_fin:{
        type: DataTypes.STRING(45),
        allowNull: true,
        field: 'res_fin'
    },
    obs_fin:{
        type: DataTypes.STRING(45),
        allowNull: true,
        field: 'obs_fin'
    },
    rut_campo:{
        type: DataTypes.STRING(45),
        allowNull: true,
        field: 'rut_campo'
    },
    url_view:{
        type: DataTypes.STRING(45),
        allowNull: true,
        field: 'url_view'
    },
    url_down:{
        type: DataTypes.STRING(45),
        allowNull: true,
        field: 'url_down'
    },
    registro_date:{
        type: DataTypes.DATE,
        allowNull: true,
        field: 'registro_date'
    },
}, {
    tableName: 'tbl_recepcion_calidad',
    timestamps: false,
});

module.exports = { Calidad };