const cron = require('node-cron');
const { sincronizar_rs_reina_sur, sincronizar_procesos_etl_cerezas } = require('../controllers/nsync_rs.controller');

// Simulación de req y res para ejecutar los controllers como funciones internas
const fakeReq = {};
const fakeRes = {
    status: function () { return this; },
    json: function (data) {
        console.log('Respuesta simulada:', data);
        return this;
    }
};

async function ejecutarTareasCron() {
    try {
        await sincronizar_rs_reina_sur(fakeReq, fakeRes);
        await sincronizar_procesos_etl_cerezas(fakeReq, fakeRes);
        console.log('Controllers ejecutados por el cron:', new Date());
    } catch (error) {
        console.error('Error en el cron:', error);
    }
}

// Programa el cron a las 7:00, 12:00, 16:00, 20:00 y 0:00
cron.schedule('0 7,12,16,20,0 * * *', ejecutarTareasCron);

ejecutarTareasCron();

