const { Sequelize } = require('sequelize');
require('dotenv').config();

const sequelize = new Sequelize(
    process.env.DB_NAME,
    process.env.DB_USER,
    process.env.DB_PASSWORD,
    {
        host: process.env.DB_HOST,
        port: process.env.DB_PORT,
        dialect: 'mysql',
        dialectOptions: {
            connectTimeout: 60000, // Aumentar el tiempo de espera a 60 segundos
        },
        logging: (msg) => console.debug(msg), // depurar
    }
);


module.exports = {
    sequelize,
};