const express = require('express');
const cors = require('cors');
const app = express();

const nsync_rs_router = require('./src/routes/nsync_rs.routes')

const dotenv = require('dotenv');
dotenv.config();

require('./src/cron/nsync_rs.cron');

const { sequelize } = require('./src/config/database'); // Base de datos

const allowedOrigins = [
    'http://localhost:3000',
    'https://localhost:3000',
    'http://localhost:8080',
    'https://localhost:8080',
    'http://localhost:8100',
    'https://192.168.17.118:8100',
    'http://192.168.17.118:8100',
    'http://127.0.0.1:8100',
    'https://localhost:8080',
    'https://cl.baikago.com',
    'http://cl.baikago.com',
    'https://col.baikago.com',
    'http://col.baikago.com',
    'https://pe.baikago.com',
    'http://pe.baikago.com',
    'https://mx.baikago.com',
    'http://mx.baikago.com',
    'https://ws3.sanjoseapps.cl',
    'http://localhost:8200',
    'http://localhost:5173',
    'http://localhost',
    'https://localhost',
    'capacitor://localhost',
    'http://10.0.2.2',
    'https://10.0.2.2',
    'http://10.0.2.2:8080',
    'https://10.0.2.2:8080',
    'http://192.168.17.118:5173',
    'http://192.168.17.239:5173',
    'http://172.27.20.107:5173',
    'http://localhost:5173',
    'http://baikago.cloud',
    'https://baikago.cloud',
    'https://mailer.baikago.cloud',
    'http://mailer.baikago.cloud',
    'https://ws.baikago.cloud',
    'http://ws.baikago.cloud',
    'https://backend.baikago.cloud',
    'http://backend.baikago.cloud',
    'https://pdf.baikago.cloud',
    'http://pdf.baikago.cloud',
    'https://cl.baikago.cloud',
    'http://cl.baikago.cloud',
    'http://mailer.baikago.com',
    'https://mailer.baikago.com',
    'http://baikago.com',
    'https://baikago.com',
    'http://34.237.83.201',
    'https://34.237.83.201',
    'http://190.95.10.100:3010',
    'https://190.95.10.100:3010'
];

app.use(cors({
    origin: function (origin, callback) {
        if (!origin || allowedOrigins.includes(origin)) {
            callback(null, true);
        } else {
            callback(new Error('Not allowed by CORS'));
        }
    },
    credentials: true,
    methods: ['GET', 'POST', 'PUT', 'DELETE'],
    allowedHeaders: ["Content-Type", "Authorization"], // Cabeceras permitidas
}));


// app.options("*", cors());

app.use(express.json());
app.use(express.urlencoded({ extended: true }));

app.use('/api', nsync_rs_router);


async function conexionA() {
    try {
        await sequelize.authenticate();
        console.log('Conexión exitosa a la base de datos');
    } catch (error) {
        console.log('Error al conectar a la base de datos:', error);
    }
}

conexionA()

// Iniciar servidor
app.listen(10001, () => {
    console.log(`Servidor corriendo en el puerto 10001`);
});
